﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ErrorExample
{
    class Program
    {
        static void Main(string[] args)
        {
            Turtle arthurTheTurtle = new Turtle
                { PlatformWidth = 0.0, PlatformHeight = 10.0, MotorSpeed = 5.0
            };

            ShowPosition(arthurTheTurtle);

            try
            {
                // Chcemy jechać prosto...
                arthurTheTurtle.LeftMotorState = MotorState.Running;
                arthurTheTurtle.RightMotorState = MotorState.Running;
                // ...przez dwie sekundy.
                arthurTheTurtle.RunFor(2.0);

                ShowPosition(arthurTheTurtle);


                // A teraz obrócimy trochę robota zgodnie z ruchem wskazówek zegara.
                arthurTheTurtle.RightMotorState = MotorState.Reversed;
                // Pi/2 sekundy powinno wystarczyć.
                arthurTheTurtle.RunFor(Math.PI / 2.0);

                ShowPosition(arthurTheTurtle);


                // A teraz jedziemy do tyłu...
                arthurTheTurtle.RightMotorState = MotorState.Reversed;
                arthurTheTurtle.LeftMotorState = MotorState.Reversed;
                // ...przez pięć sekund...
                arthurTheTurtle.RunFor(5);

                ShowPosition(arthurTheTurtle);

                // ...po czym obracamy się w przeciwnym kierunku...
                arthurTheTurtle.RightMotorState = MotorState.Running;
                // ...przez pi/4 sekundy, co da nam 45 stopni.
                arthurTheTurtle.RunFor(Math.PI / 4.0);

                ShowPosition(arthurTheTurtle);

                // I znowu pojedziemy trochę do tyłu.
                arthurTheTurtle.RightMotorState = MotorState.Reversed;
                arthurTheTurtle.LeftMotorState = MotorState.Reversed;
                arthurTheTurtle.RunFor(Math.Cos(Math.PI / 4.0));

                ShowPosition(arthurTheTurtle);
            }
            // Listing 6-19. Wykorzystanie właściwości InnerException.
            catch (InvalidOperationException e)
            {
                Console.WriteLine("Błąd działania robota:");
                Console.WriteLine(e.Message);
            }
            catch (Exception e1)
            {
                // Pętla przeglądająca wszystkie wewnętrzne wyjątki
                // i wyświetlająca ich komunikaty
                Exception current = e1;
                while (current != null)
                {
                    Console.WriteLine(current.Message);
                    current = current.InnerException;
                }
            }
            finally
            {
                Console.WriteLine("Czekamy w bloku finally...");
                Console.ReadKey();
            }
        }

        private static void ShowPosition(Turtle arthurTheTurtle)
        {
            Console.WriteLine(
                "Artur znajduje się w miejscu ({0}) i jest obrócony w kierunku {1:0.00} radianów.",
            arthurTheTurtle.CurrentPosition,
            arthurTheTurtle.CurrentOrientation);
        }
    }
}
